% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace.R
\name{[<-.matrixset}
\alias{[<-.matrixset}
\title{Replace Parts of a matrixset}
\usage{
\method{[}{matrixset}(x, i = NULL, j = NULL, matrix = NULL) <- value
}
\arguments{
\item{x}{\code{matrixset} object from which to replace element(s)}

\item{i, j}{Indices specifying elements to replace. Indices are numeric or
character vectors or empty (\code{NULL}). Note that treating \code{NULL} as empty
differs from the usual replacement, where it is treated as \code{integer(0)}.
Here a \code{NULL} (empty) results in selecting all rows or columns.

\if{html}{\out{<div class="sourceCode">}}\preformatted{Numeric values are coerced to integer as by [as.integer()] (and hence
truncated towards zero).

Character vectors will be matched to the dimnames of the object.

Can also be logical vectors, indicating elements/slices to replace Such
vectors are **NOT** recycled, which is an important difference with usual
matrix replacement. It means that the logical vector must match the
object dimension in length.

Can also be negative integers, indicating elements/slices to leave out of
the replacement.

When indexing, a single argument `i` can be a matrix with two columns.
This is treated as if the first column was the `i` index and the second
column the `j` index.
}\if{html}{\out{</div>}}}

\item{matrix}{index specifying matrix or matrices to replace. Index is
numeric or character vectors or empty (\code{NULL}). Note
that treating \code{NULL} as empty differs from the usual
replacement, where it is treated as \code{integer(0)}. Here
a \code{NULL} (empty) results in replacing all matrices.

Numeric values are coerced to integer as by \code{\link[=as.integer]{as.integer()}} (and hence
truncated towards zero).

Character vectors will be matched to the matrix names of the object.

Can also be logical vectors, indicating elements/slices to replace. Such
vectors are \emph{NOT} recycled, which is an important difference with usual
matrix replacement. It means that the \code{logical} vector must match the
number of matrices in length.

Can also be negative integers, indicating elements/slices to leave out of
the replacement.}

\item{value}{object to use as replacement value}
}
\value{
A \code{matrixset}, with proper elements replaced.
}
\description{
Replace whole or parts of some - or all - matrices of a \code{matrixset}.
}
\details{
If \code{matrix} is left unspecified (or given as \code{NULL}), all matrices will be
replaced by \code{value}. How replacement exactly occurs depends on \code{value} itself.

If \code{value} is a single atomic \code{vector} (this excludes lists) or \code{matrix},
relevant subscripts of all requested matrices will be replaced by the same
\code{value}. This is conditional to the dimensions being compatible.

Alternatively, \code{value} can be a list of atomic vectors/matrices. If \code{value}
has a single element, the same rules as above apply. Otherwise, the length
of \code{value} must match the number of matrices for which subscripts have to be
replaced.

If the list elements are named, the names are matched to the names of the
matrices that need replacement - in which case \code{value} needs not to be the
same length.

A final possibility for \code{value} is for it to be \code{NULL}. In this case, target
matrices are turned to \code{NULL}.
}
\section{vector \code{value}}{

Contrarily to \code{matrix} replacement, when submitting an atomic \code{vector}
\code{value}, dimensions must match exactly.
}

\section{Replacing \code{NULL} matrices}{

Replacing subscripts of \code{NULL} matrices is not possible, unless \code{value} is
itself \code{NULL}, or a matrix the same dimensions (number of rows and columns)
as \code{x}. If \code{x} has dimnames, \code{value} must have the same dimnames.
}

\examples{
# an hypothetical example of students that failed 3 courses and their results
# after remedial class

# you can replace a line for all matrices at once. In the example, the "wrong"
# tag refers to the fact that the 'failure' results do not make sense after
# replacement
student_results_wrong <- student_results
student_results_wrong["student 2",,] <- c(0.81, 0.88, 0.71) # obviously, integer index works too
# note how all matrices had the same replacement
student_results_wrong

# this already makes more sense in the context of the example
student_results[2,,] <- list(c(0,0.45,0.1), c(0.81, 0.88, 0.71))
student_results

# or even these two equivalent commands
student_results["student 2",,"remedial"] <- c(0.77, 0.83, 0.75)
student_results[2,,2] <- matrix(c(0.77, 0.83, 0.75), 1, 3)


}
