% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Binary.R
\name{logarithmicmean_byname}
\alias{logarithmicmean_byname}
\title{Name- and element-wise logarithmic mean of matrices}
\usage{
logarithmicmean_byname(a, b, base = exp(1))
}
\arguments{
\item{a}{first operand (a matrix or constant value or lists of same).}

\item{b}{second operand (a matrix or constant value or lists of same).}

\item{base}{the base of the logarithm used when computing the logarithmic mean.
(Default is \code{base = exp(1)}.)}
}
\value{
A matrix representing the name-wise logarithmic mean
of \code{a} and \code{b}.
}
\description{
The logarithmic mean of corresponding entries of \code{a} and \code{b} is
\code{0} if \code{a = 0} or \code{b = 0},
\code{a} if \code{a = b}, or
\code{(b - a) / (log(b) - log(a))} otherwise.
}
\details{
This function performs a union and sorting of row and column names
prior to performing logarithmic mean.
Zeroes are inserted for missing matrix elements.

Internally, the third condition is implemented as
\code{(b - a) / log(b/a)}.

Note that \code{(b - a) / log(b/a) = (a - b) / log(a/b)},
so logarithmic mean is commutative;
the order of arguments \strong{\code{a}} and \strong{\code{b}}
does not change the result.
}
\examples{
library(dplyr)
m1 <- matrix(c(1:6), nrow = 3, ncol = 2) \%>\% 
  setrownames_byname(c("r1", "r2", "r3")) \%>\% setcolnames_byname(c("c1", "c2")) \%>\% 
  setrowtype("row") \%>\% setcoltype("col")
m2 <- matrix(c(7:12), nrow = 3, ncol = 2) \%>\% 
  setrownames_byname(c("r2", "r3", "r4")) \%>\% setcolnames_byname(c("c2", "c3")) \%>\% 
  setrowtype("row") \%>\% setcoltype("col")
logarithmicmean_byname(m1, m2)
# This also works with lists
logarithmicmean_byname(list(m1, m1), list(m2, m2))
DF <- data.frame(m1 = I(list()), m2 = I(list()))
DF[[1,"m1"]] <- m1
DF[[2,"m1"]] <- m1
DF[[1,"m2"]] <- m2
DF[[2,"m2"]] <- m2
logarithmicmean_byname(DF$m1, DF$m2)
DF \%>\% mutate(logmeans = logarithmicmean_byname(m1, m2))
}
