% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_manova_disp.R
\name{mc_manova_disp}
\alias{mc_manova_disp}
\title{MANOVA-Type Test for Dispersion Components of mcglm Models}
\usage{
mc_manova_disp(object, idx, effect_names, ...)
}
\arguments{
\item{object}{An object of class \code{"mcglm"}.}

\item{idx}{An integer vector defining the grouping structure
of dispersion parameters to be tested.}

\item{effect_names}{A character vector with labels for the tested
dispersion effects.}

\item{...}{Further arguments (currently not used).}
}
\value{
A data frame containing the MANOVA-type test results for the
dispersion parameters with the following columns:
\describe{
  \item{Effects}{Names of the tested dispersion effects.}
  \item{Df}{Degrees of freedom associated with each effect.}
  \item{Hotelling-Lawley}{Hotelling–Lawley trace statistic.}
  \item{Chi-square}{Chi-square test statistic.}
  \item{p-value}{P-values from the chi-square approximation.}
}
}
\description{
Performs a MANOVA-type Wald test for the dispersion parameters
of multivariate covariance generalized linear models fitted
using \code{\link{mcglm}}. The test is based on quadratic forms
of the estimated dispersion parameters and their covariance
matrix, yielding statistics analogous to the Hotelling–Lawley trace.
}
\seealso{
\code{\link{mcglm}}, \code{\link{mc_manova}},
  \code{\link{coef.mcglm}}, \code{\link{vcov.mcglm}}
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
