% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetPartialEfSizes.R
\name{GetPartialEfSizes}
\alias{GetPartialEfSizes}
\title{GetPartialEfSizes}
\usage{
GetPartialEfSizes(
  featureMat,
  metaMat,
  metaDeconfOutput,
  doRanks = NA,
  randomVar = NA,
  fixedVar = NA
)
}
\arguments{
\item{featureMat}{a data frame with row(sample ID)
and column(feature such as metabolite or microbial OTU )
names, listing features for all samples}

\item{metaMat}{a data frame with row(sample ID) and
column(meta data such as age,BMI and all possible confounders)
names listing metadata for all samples. first column should be case status
with case=1 and control=0. All binary variables need to be in 0/1 syntax!}

\item{metaDeconfOutput}{long format output of the MetaDeconfound output created for the
supplied featureMat and metaMat}

\item{doRanks}{optional vector of metavariable names, that should be rank
transformed when building linear models in the doconfounding step}

\item{randomVar}{optional vector of metavariable names to be treated as
random effect variables. These variables will not be tested for naive
associations and will not be included as potential confounders,
but will be added as random effects "+ (1|variable)" into any models being built.
Any associations reducible to the supplied random effect(s) will be labeled
 as "NS". Note: Ps, Qs, Ds are computed independently and thereby not changed
 through inclusion of random effects.}

\item{fixedVar}{optional vector of metavariable names to be treated as
fixed effect variables. These variabels will not be tested for naive
associations and will not be included as potential confounders,
but will be added as fixed effects "+ variable" into any models being built.
Any associations reducible to the supplied fixed effect(s) will be labeled
as "NS". Note: Ps, Qs, Ds are computed independently and thereby not changed
through inclusion of fixed effects.}
}
\value{
long format data.frame similar to Metadeconfound() output
}
\description{
GetPartialEfSizes takes \link[metadeconfoundR]{MetaDeconfound} output and
genarates partial effect sizes for all significant associations
}
\details{
for more details and explanations please see the package vignette.
}
\examples{
data(reduced_feature)
data(metaMatMetformin)
\donttest{

example_output <- MetaDeconfound(featureMat = reduced_feature,
                                  metaMat = metaMatMetformin,
                                  logLevel = "ERROR",
                                  returnLong = TRUE)
#
ex_out_partial <- GetPartialEfSizes(featureMat = reduced_feature,
                                      metaMat = metaMatMetformin,
                                      metaDeconfOutput = example_output)
}

}
