% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anda.R
\name{anda_variables}
\alias{anda_variables}
\title{Query ANDA variable metadata from the API}
\usage{
anda_variables(survey_type = "ech", var_names = NULL)
}
\arguments{
\item{survey_type}{Character survey type (default "ech")}

\item{var_names}{Character vector of variable names to look up. If NULL,
returns all variables for the survey type.}
}
\value{
A data.frame with columns: name, label, type
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Fetches variable metadata (labels, types, value labels) from the
metasurvey API's ANDA endpoint.
}
\examples{
\dontrun{
anda_variables("ech", c("pobpcoac", "e27"))
}
}
\seealso{
Other anda: 
\code{\link{anda_download_microdata}()},
\code{\link{api_get_anda_variables}()}
}
\concept{anda}
