% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stata_parser.R
\name{parse_do_file}
\alias{parse_do_file}
\title{Parse a STATA .do file into structured commands}
\usage{
parse_do_file(do_file, encoding = "latin1")
}
\arguments{
\item{do_file}{Path to a STATA .do file}

\item{encoding}{File encoding (default "latin1" for legacy STATA files)}
}
\value{
A list of StataCommand lists, each with fields:
cmd, args, if_clause, options, raw_line, line_num, capture
}
\description{
Reads a .do file and returns a list of parsed command objects.
Handles comment stripping, line continuation, loop expansion,
and command tokenization.
}
\examples{
\donttest{
tf <- tempfile(fileext = ".do")
writeLines(c("gen age2 = edad^2", "replace sexo = 1 if sexo == ."), tf)
cmds <- parse_do_file(tf)
length(cmds)
cmds[[1]]$cmd
}
}
\seealso{
Other transpiler: 
\code{\link{parse_stata_labels}()},
\code{\link{transpile_coverage}()},
\code{\link{transpile_stata}()},
\code{\link{transpile_stata_module}()}
}
\concept{transpiler}
