% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe_tidy_api.R
\name{recipe_certification}
\alias{recipe_certification}
\title{Create a recipe certification}
\usage{
recipe_certification(level = "community", certified_by = NULL, notes = NULL)
}
\arguments{
\item{level}{Character. One of \code{"community"}
(default), \code{"reviewed"}, or
\code{"official"}.}

\item{certified_by}{RecipeUser or \code{NULL} (default \code{NULL}). Required for
reviewed/official.}

\item{notes}{Character or \code{NULL} (default \code{NULL}). Additional notes.}
}
\value{
A \code{\link{RecipeCertification}} object.
}
\description{
Creates a \code{\link{RecipeCertification}} object. Typically you would use
\code{\link{certify_recipe}} to certify a recipe in a pipeline instead.
}
\examples{
# Default community certification
cert <- recipe_certification()

# Official certification
inst <- recipe_user("IECON", type = "institution")
cert <- recipe_certification("official", certified_by = inst)

}
\seealso{
\code{\link{RecipeCertification}}, \code{\link{certify_recipe}}

Other tidy-api: 
\code{\link{RecipeCategory}},
\code{\link{RecipeCertification}},
\code{\link{RecipeUser}},
\code{\link{add_category}()},
\code{\link{certify_recipe}()},
\code{\link{default_categories}()},
\code{\link{filter_recipes}()},
\code{\link{filter_workflows}()},
\code{\link{find_workflows_for_recipe}()},
\code{\link{list_recipes}()},
\code{\link{list_workflows}()},
\code{\link{rank_recipes}()},
\code{\link{rank_workflows}()},
\code{\link{recipe_category}()},
\code{\link{recipe_user}()},
\code{\link{remove_category}()},
\code{\link{search_recipes}()},
\code{\link{search_workflows}()},
\code{\link{set_user_info}()},
\code{\link{set_version}()}
}
\concept{tidy-api}
