% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{reproduce_workflow}
\alias{reproduce_workflow}
\title{Reproduce a workflow from its published specification}
\usage{
reproduce_workflow(wf, data_path = NULL, dest_dir = tempdir())
}
\arguments{
\item{wf}{RecipeWorkflow object}

\item{data_path}{Character path to survey microdata. If NULL, attempts to
download from ANDA for ECH surveys.}

\item{dest_dir}{Character directory for downloaded files}
}
\value{
Survey object with recipes applied and weight configuration set
}
\description{
Given a RecipeWorkflow (typically fetched from the registry), downloads
the data, resolves the weight configuration, fetches referenced recipes,
and returns a Survey object ready for \code{workflow()} estimation.
}
\examples{
\dontrun{
wf <- api_get_workflow("w_123")
svy <- reproduce_workflow(wf)
}
}
\seealso{
Other workflows: 
\code{\link{RecipeWorkflow-class}},
\code{\link{evaluate_cv}()},
\code{\link{print.RecipeWorkflow}()},
\code{\link{publish_workflow}()},
\code{\link{read_workflow}()},
\code{\link{save_workflow}()},
\code{\link{workflow}()},
\code{\link{workflow_from_list}()},
\code{\link{workflow_table}()}
}
\concept{workflows}
