% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univdist.R
\name{pp.score}
\alias{pp.score}
\title{Score vector for the Poisson process of threshold exceedances}
\usage{
pp.score(par, dat, u, np = 1)
}
\arguments{
\item{par}{vector of \code{loc}, \code{scale} and \code{shape}}

\item{dat}{sample vector}

\item{u}{threshold}

\item{np}{number of periods of observations. This is a \emph{post hoc} adjustment for the intensity so that the parameters of the model coincide with those of a generalized extreme value distribution with block size \code{length(dat)/np}.}
}
\value{
score vector of NHPP
}
\description{
Returns the score vector of the NHPP.
}
\seealso{
\code{\link{pp}}
}
\keyword{internal}
