% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mhp.R
\name{get_lambda}
\alias{get_lambda}
\title{Extract Optimal Lambda}
\usage{
get_lambda(x)
}
\arguments{
\item{x}{Result from \code{\link{mhp_filter}} (either data.table or mhp object).}
}
\value{
Integer. The optimal lambda value.
}
\description{
Extract the optimal smoothing parameter lambda from Modified HP filter results.
}
\examples{
set.seed(123)
result <- mhp_filter(cumsum(rnorm(100)), max_lambda = 10000)
get_lambda(result)

# With mhp object
result_obj <- mhp_filter(cumsum(rnorm(100)), max_lambda = 10000, as_dt = FALSE)
get_lambda(result_obj)

}
