% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SummaryReport.R
\name{summary.SummaryReport}
\alias{summary.SummaryReport}
\alias{print.summary.SummaryReport}
\alias{print.SummaryReport}
\alias{rbind.SummaryReport}
\alias{ascii.SummaryReport}
\alias{ICER.SummaryReport}
\alias{ascii.ICER.SummaryReport}
\title{summary method for a SummaryReport object}
\usage{
\method{summary}{SummaryReport}(object, ...)

\method{print}{summary.SummaryReport}(x, ...)

\method{print}{SummaryReport}(x, ...)

\method{rbind}{SummaryReport}(...)

\method{ascii}{SummaryReport}(
  x,
  include.rownames = FALSE,
  include.colnames = TRUE,
  header = TRUE,
  digits = c(0, 3, 2, 2, 4, 4),
  ...
)

\method{ICER}{SummaryReport}(object1, object2, ...)

\method{ascii}{ICER.SummaryReport}(
  x,
  include.rownames = TRUE,
  include.colnames = TRUE,
  header = TRUE,
  digits = c(1, 1, 3, 3, 1, 1, 3, 3, 1),
  rownames = c("Reference", "Treatment"),
  colnames = c("Costs", "(se)", "QALYs", "(se)", "Costs", "(se)", "QALYs", "(se)",
    "ICER"),
  tgroup = c("Total", "Incremental"),
  n.tgroup = c(4, 5),
  ...
)
}
\arguments{
\item{object}{SummaryReport object}

\item{...}{other arguments to pass to ascii}

\item{x}{an ICER.SummaryReport object}

\item{include.rownames}{logical for whether to include rownames (default=FALSE)}

\item{include.colnames}{logical for whether to include colnames (default=TRUE)}

\item{header}{logical for whether to include the header (default=TRUE)}

\item{digits}{vector of the number of digits to use for each column}

\item{object1}{SummaryReport object (reference)}

\item{object2}{SummaryReport object}

\item{rownames}{rownames for output}

\item{colnames}{colnames for output}

\item{tgroup}{tgroup arg passed to ascii}

\item{n.tgroup}{arg passed to ascii}
}
\value{
a list of class summary.SummaryReport with components:
\describe{
\item{n}{Number of simulations}
\item{indivip}{boolean with whether individual values were retained}
\item{utilityDiscountRate}{discount rate for utilities/QALYs}
\item{costDiscountRate}{discount rate for costs}
\item{QALE}{Quality-adjusted life expectancy (discounted)}
\item{LE}{Life expectancy (not discounted)}
\item{ECosts}{Life-time expected costs (discounted)}
\item{se.QALE}{standard error for QALE}
\item{se.Ecosts}{standard error Ecosts}
}

a SummaryReport object

ascii object

a list of type ICER.SummaryReport with components:
\describe{
\item{n}{number of simulations}
\item{utilityDiscountRate}{Discount rate for the utilities/QALE}
\item{costDiscountRate}{Discount rate for the costs}
\item{s1}{summary for object1}
\item{s2}{summary for object2}
\item{dQALE}{QALE for object2 minus QALE for object1}
\item{dCosts}{Costs for object2 minus costs for object1}
\item{ICER}{change of costs divided by change in QALEs}
\item{se.dQALE}{standard error for dQALE}
\item{se.dCosts}{standard error for dCosts}
}

ascii object
}
\description{
At present, this passes the object to summary and then prints
}
