% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micvar.R
\name{sim_var}
\alias{sim_var}
\title{Simulate data from a vector autoregressive model with specified coefficient matrices}
\usage{
sim_var(A, n, mu = NULL, Sigma = NULL, burn_in = 500)
}
\arguments{
\item{A}{List of coefficient matrices. Each element in A must be a square matrix. Dimension of matrix determines the number of variables. Length of A determines the order of the process. In the case of univariate time series each entry of A should be a \code{1 x 1} matrix.}

\item{n}{Integer. Number of data points to simulate.}

\item{mu}{Vector (default 0s). Means of Gaussian innovations.}

\item{Sigma}{Square matrix (default Identity). Variance of Gaussian innovations.}

\item{burn_in}{Integer (default 500). Number of observations used to start up simulated process. In total \code{n + burn_in} observations are simulated but the first \code{burn_in} are discarded.}
}
\value{
\code{n x k} data matrix.
}
\description{
Simulates data from a stable vector autoregressive model with Gaussian innovations and specified coefficient matrices. Stability of the process is verified using \link{verify_stability}.
}
\examples{
# multivariate
VAR3_2_A <- list(gen_coef_mat(3, 0.1, 0.3, 0.8), # lag 1
                 gen_coef_mat(3, 0.1, 0.4 , 0.5)) # lag 2
x <- sim_var(VAR3_2_A, n = 1000)

# univariate
AR2 <- list(matrix(0.5), matrix(0.2))
x <- sim_var(AR2, n = 1000)

# non-identity covariance of Gaussian innovations
Sigma <- matrix(c(1,0.5,0.9,0.5,1.5,0.7,0.9,0.7,1.25), nrow = 3)
x <- sim_var(VAR3_2_A, n = 1000, Sigma = Sigma)

}
