# WARNING - Generated by {fusen} from dev/flat_teaching.Rmd: do not edit by hand

# Basic functionality test
test_that("r2p_nest returns correct structure with mtcars", {
  # Test with basic parameters
  result <- r2p_nest(
    mtcars,
    rows2bind = "cyl",
    by = c("hp", "drat", "wt")
  )
  
  # Check return structure
  expect_true(is.data.table(result))
  expect_true(all(c("name", "data") %in% names(result)))
  expect_equal(ncol(result), 2)
  
  # Check number of groups matches by columns
  expect_equal(nrow(result), 3)  # Should match length of by columns
  expect_equal(sort(unique(as.character(result$name))), sort(c("hp", "drat", "wt")))
  
  # Check nested data structure
  expect_true(all(sapply(result$data, is.data.table)))
  first_nested_dt <- result$data[[1]]
  
  # Check that other columns are preserved in nested data
  expected_cols <- setdiff(names(mtcars), c("hp", "cyl"))
  expect_true(all(expected_cols %in% names(first_nested_dt)))
})

# Test different nest_type options
test_that("r2p_nest handles different nest_type correctly with mtcars", {
  # Test with dt
  result_dt <- r2p_nest(
    mtcars,
    rows2bind = "cyl",
    by = "hp",
    nest_type = "dt"
  )
  expect_true(all(sapply(result_dt$data, is.data.table)))
  
  # Test with df
  result_df <- r2p_nest(
    mtcars,
    rows2bind = "cyl",
    by = "hp",
    nest_type = "df"
  )
  expect_true(all(sapply(result_df$data, is.data.frame)))
  expect_false(any(sapply(result_df$data, is.data.table)))
})

# Test column specification methods
test_that("r2p_nest handles different column specifications correctly with mtcars", {
  # Test with column names
  result_names <- r2p_nest(
    mtcars,
    rows2bind = "cyl",
    by = c("hp", "drat")
  )
  
  # Test with column indices
  mtcars_cols <- names(mtcars)
  hp_index <- which(mtcars_cols == "hp")
  drat_index <- which(mtcars_cols == "drat")
  cyl_index <- which(mtcars_cols == "cyl")
  
  result_indices <- r2p_nest(
    mtcars,
    rows2bind = cyl_index,
    by = c(hp_index, drat_index)
  )
  
  # Results should be identical
  expect_equal(result_names, result_indices)
})

# Error handling tests
test_that("r2p_nest handles invalid inputs correctly with mtcars", {
  # Missing by parameter
  expect_error(r2p_nest(mtcars, rows2bind = "cyl", by = character(0)))
  
  # Invalid rows2bind
  expect_error(r2p_nest(mtcars, rows2bind = c("cyl", "hp"), by = "hp"))
  expect_error(r2p_nest(mtcars, rows2bind = "nonexistent", by = "hp"))
  expect_error(r2p_nest(mtcars, rows2bind = 100, by = "hp"))
  
  # Invalid by parameter
  expect_error(r2p_nest(mtcars, rows2bind = "cyl", by = "nonexistent"))
  expect_error(r2p_nest(mtcars, rows2bind = "cyl", by = 100))
  
  # Invalid nest_type
  expect_error(r2p_nest(mtcars, rows2bind = "cyl", by = "hp", nest_type = "invalid"))
})

# Test data consistency
test_that("r2p_nest maintains data consistency with mtcars", {
  result <- r2p_nest(
    mtcars,
    rows2bind = "cyl",
    by = c("hp", "drat", "wt")
  )
  
  # Check that all by variables are present in names
  expect_true(all(c("hp", "drat", "wt") %in% unique(result$name)))
  
  # Check that nested data contains expected columns
  first_nested_dt <- result$data[[1]]
  expected_cols <- setdiff(names(mtcars), c("hp", "cyl"))
  expect_true(all(expected_cols %in% names(first_nested_dt)))
  
  # Check that row counts are preserved
  expect_equal(nrow(first_nested_dt), nrow(mtcars))
})

# Test multiple by columns
test_that("r2p_nest handles multiple by columns correctly with mtcars", {
  # Test with single by column
  result_single <- r2p_nest(mtcars, rows2bind = "cyl", by = "hp")
  expect_equal(nrow(result_single), 1)
  
  # Test with multiple by columns
  result_multiple <- r2p_nest(mtcars, rows2bind = "cyl", by = c("hp", "drat", "wt"))
  expect_equal(nrow(result_multiple), 3)
  
  # Check that all by columns are represented
  expect_equal(sort(as.character(unique(result_multiple$name))), sort(c("hp", "drat", "wt")))
})
