# WARNING - Generated by {fusen} from dev/flat_teaching.Rmd: do not edit by hand

# Test basic functionality
test_that("mintyr_examples lists files correctly without pattern", {
  # Get all files
  files <- mintyr_examples()
  
  expect_type(files, "character")
  expect_true(length(files) > 0)
})

# Test pattern matching
test_that("mintyr_examples filters files with pattern", {
  # Test with .csv pattern
  csv_files <- mintyr_examples(pattern = "\\.csv$")
  expect_true(all(grepl("\\.csv$", csv_files)))
  
  # Test with non-existing pattern
  no_files <- mintyr_examples(pattern = "nonexistent")
  expect_length(no_files, 0)
})

# Test input validation
test_that("mintyr_examples validates pattern parameter", {
  # Test NULL pattern (default)
  expect_type(mintyr_examples(NULL), "character")
  
  # Test invalid pattern types
  expect_error(mintyr_examples(pattern = 123))
  expect_error(mintyr_examples(pattern = list()))
})

# Test edge cases
test_that("mintyr_examples handles edge cases", {
  # Test empty pattern
  empty_pattern <- mintyr_examples(pattern = "")
  expect_type(empty_pattern, "character")
  
  # Test pattern with special characters
  special_pattern <- mintyr_examples(pattern = "^.*\\.csv$")
  expect_type(special_pattern, "character")
})
