% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_output_trafos.R
\docType{data}
\name{mlr_output_trafos}
\alias{mlr_output_trafos}
\title{Dictionary of Output Transformations}
\format{
\link[R6:R6Class]{R6::R6Class} object inheriting from \link[mlr3misc:Dictionary]{mlr3misc::Dictionary}.
}
\description{
A simple \link[mlr3misc:Dictionary]{mlr3misc::Dictionary} storing objects of class \link{OutputTrafo}.
Each output transformation has an associated help page, see \code{mlr_output_trafos[id]}.

For a more convenient way to retrieve and construct an output trafo, see \code{\link[=ot]{ot()}}.
}
\section{Methods}{

See \link[mlr3misc:Dictionary]{mlr3misc::Dictionary}.
}

\examples{
library(data.table)
as.data.table(mlr_output_trafos)
ot("standardize")
}
\seealso{
Sugar function: \code{\link[=ot]{ot()}}

Other Dictionary: 
\code{\link{mlr_acqfunctions}},
\code{\link{mlr_acqoptimizers}},
\code{\link{mlr_input_trafos}},
\code{\link{mlr_loop_functions}},
\code{\link{mlr_result_assigners}}

Other Output Transformation: 
\code{\link{OutputTrafo}},
\code{\link{OutputTrafoLog}},
\code{\link{OutputTrafoStandardize}}
}
\concept{Dictionary}
\concept{Output Transformation}
\keyword{datasets}
