% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimInstanceBatchSingleCrit.R
\name{autoplot.OptimInstanceBatchSingleCrit}
\alias{autoplot.OptimInstanceBatchSingleCrit}
\title{Plots for Optimization Instances}
\usage{
\method{autoplot}{OptimInstanceBatchSingleCrit}(
  object,
  type = "marginal",
  cols_x = NULL,
  trafo = FALSE,
  learner = mlr3::lrn("regr.ranger"),
  grid_resolution = 100,
  batch = NULL,
  theme = theme_minimal(),
  ...
)
}
\arguments{
\item{object}{(\link[bbotk:OptimInstanceBatchSingleCrit]{bbotk::OptimInstanceBatchSingleCrit}).}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{cols_x}{(\code{character()})\cr
Column names of x values.
By default, all untransformed x values from the search space are plotted.
Transformed hyperparameters are prefixed with \code{x_domain_}.}

\item{trafo}{(\code{logical(1)})\cr
If \code{FALSE} (default), the untransformed x values are plotted.
If \code{TRUE}, the transformed x values are plotted.}

\item{learner}{(\link[mlr3:Learner]{mlr3::Learner})\cr
Regression learner used to interpolate the data of the surface plot.}

\item{grid_resolution}{(\code{numeric()})\cr
Resolution of the surface plot.}

\item{batch}{(\code{integer()})\cr
The batch number(s) to limit the plot to.
The default is all batches.}

\item{theme}{(\code{\link[ggplot2:theme]{ggplot2::theme()}})\cr
The \code{\link[ggplot2:ggtheme]{ggplot2::theme_minimal()}} is applied by default to all plots.}

\item{...}{(ignored).}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
Visualizations for \link[bbotk:OptimInstanceBatchSingleCrit]{bbotk::OptimInstanceBatchSingleCrit}.
The argument \code{type} controls what kind of plot is drawn.
Possible choices are:
\itemize{
\item \code{"marginal"} (default): Scatter plots of x versus y.
The color of the points shows the batch number.
\item \code{"performance"}: Scatter plots of batch number versus y
\item \code{"parameter"}: Scatter plots of batch number versus input.
The color of the points shows the y values.
\item \code{"parallel"}: Parallel coordinates plot.
x values are rescaled by \code{(x - mean(x)) / sd(x)}.
\item \code{"points"}: Scatter plot of two x dimensions versus y values.
The color of the points shows the y values.
\item \code{"surface"}: Surface plot of two x dimensions versus y values.
The y values are interpolated with the supplied \link[mlr3:Learner]{mlr3::Learner}.
\item \code{"pairs"}: Plots all x and y values against each other.
\item \code{"incumbent"}: Plots the incumbent versus the number of configurations.
}
}
\examples{
\donttest{
if (mlr3misc::require_namespaces(c("paradox", "bbotk", "patchwork"), quietly = TRUE)) {
library(bbotk)

fun = function(xs) {
  c(y = -(xs[[1]] - 2)^2 - (xs[[2]] + 3)^2 + 10)
}
domain = ps(
  x1 = p_dbl(-10, 10),
  x2 = p_dbl(-5, 5)
)
codomain = ps(
  y = p_dbl(tags = "maximize")
)
obfun = ObjectiveRFun$new(
  fun = fun,
  domain = domain,
  codomain = codomain
)

instance = oi(objective = obfun, terminator = trm("evals", n_evals = 20))

optimizer = opt("random_search", batch_size = 2)
optimizer$optimize(instance)

# plot y versus batch number
print(autoplot(instance, type = "performance"))

# plot x1 values versus performance
print(autoplot(instance, type = "marginal", cols_x = "x1"))

# plot parallel coordinates plot
print(autoplot(instance, type = "parallel"))

# plot pairs
print(autoplot(instance, type = "pairs"))

# plot incumbent
print(autoplot(instance, type = "incumbent"))
}
}
}
