% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.mltsfit}
\alias{summary.mltsfit}
\title{Create a summary of a fitted model with class \code{mltsfit}}
\usage{
\method{summary}{mltsfit}(
  object,
  priors = FALSE,
  se = FALSE,
  prob = 0.95,
  bpe = c("mean"),
  digits = 3,
  flag_signif = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{mltsfit}.}

\item{priors}{Add prior information (default = FALSE).}

\item{se}{Logical. Should the Monte Carlo Standard Error be included
in the summary? Defaults to \code{FALSE}.}

\item{prob}{A value between 0 and 1 to indicate the width of the credible
interval. Default is .95.}

\item{bpe}{Bayesian posterior estimate can be either "mean" (the default)
or the "median" of the posterior distribution.}

\item{digits}{Number of digits.}

\item{flag_signif}{Add significance flags based on \code{prob} (default = FALSE).}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
A summary of model parameters.
}
\description{
Create a summary of a fitted model with class \code{mltsfit}
}
\examples{
\donttest{
# build simple vector-autoregressive mlts model for two time-series variables
var_model <- mlts_model(q = 2)

# fit model with (artificial) dataset ts_data
fit <- mlts_fit(
  model = var_model,
  data = ts_data,
  ts = c("Y1", "Y2"), # time-series variables
  id = "ID", # identifier variable
  time = "time",
  tinterval = 1 # interval for approximation of continuous-time dynamic model,
)

# inspect model summary
summary(fit)
}
}
