% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov_struct.R
\name{covariance_types}
\alias{covariance_types}
\alias{cov_types}
\title{Covariance Types}
\usage{
cov_types(
  form = c("name", "abbr", "habbr"),
  filter = c("heterogeneous", "spatial")
)
}
\arguments{
\item{form}{(\code{character})\cr covariance structure type name form. One or
more of \code{"name"}, \code{"abbr"} (abbreviation), or \code{"habbr"} (heterogeneous
abbreviation).}

\item{filter}{(\code{character})\cr covariance structure type filter. One or
more of \code{"heterogeneous"} or \code{"spatial"}.}
}
\value{
A character vector of accepted covariance structure type names and
abbreviations.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\note{
The \strong{ante-dependence} covariance structure in this package refers to
homogeneous ante-dependence, while the ante-dependence covariance structure
from SAS \verb{PROC MIXED} refers to heterogeneous ante-dependence and the
homogeneous version is not available in SAS.

For all non-spatial covariance structures, the time variable must
be coded as a factor.
\subsection{Spatial Covariance structures:}{

\tabular{clll}{

\strong{Structure}
\tab \strong{Description}
\tab \strong{Parameters}
\tab \strong{\eqn{(i, j)} element}
\cr

sp_exp
\tab spatial exponential
\tab \eqn{2}
\tab \eqn{\sigma^{2}\rho^{-d_{ij}}}

}

where \eqn{d_{ij}} denotes the Euclidean distance between time points
\eqn{i} and \eqn{j}.
}
}
\section{Abbreviations for Covariance Structures}{

\subsection{Common Covariance Structures:}{

\tabular{clll}{

\strong{Structure}
\tab \strong{Description}
\tab \strong{Parameters}
\tab \strong{\eqn{(i, j)} element}
\cr

ad
\tab Ante-dependence
\tab \eqn{m}
\tab \eqn{\sigma^{2}\prod_{k=i}^{j-1}\rho_{k}}
\cr

adh
\tab Heterogeneous ante-dependence
\tab \eqn{2m-1}
\tab \eqn{\sigma_{i}\sigma_{j}\prod_{k=i}^{j-1}\rho_{k}}
\cr

ar1
\tab First-order auto-regressive
\tab \eqn{2}
\tab \eqn{\sigma^{2}\rho^{\left \vert {i-j} \right \vert}}
\cr

ar1h
\tab Heterogeneous first-order auto-regressive
\tab \eqn{m+1}
\tab \eqn{\sigma_{i}\sigma_{j}\rho^{\left \vert {i-j} \right \vert}}
\cr

cs
\tab Compound symmetry
\tab \eqn{2}
\tab \eqn{\sigma^{2}\left[ \rho I(i \neq j)+I(i=j) \right]}
\cr

csh
\tab Heterogeneous compound symmetry
\tab \eqn{m+1}
\tab \eqn{\sigma_{i}\sigma_{j}\left[ \rho I(i \neq j)+I(i=j) \right]}
\cr

toep
\tab Toeplitz
\tab \eqn{m}
\tab \eqn{\sigma_{\left \vert {i-j} \right \vert +1}}
\cr

toeph
\tab Heterogeneous Toeplitz
\tab \eqn{2m-1}
\tab \eqn{\sigma_{i}\sigma_{j}\rho_{\left \vert {i-j} \right \vert}}
\cr

us
\tab Unstructured
\tab \eqn{m(m+1)/2}
\tab \eqn{\sigma_{ij}}

}

where \eqn{i} and \eqn{j} denote \eqn{i}-th and \eqn{j}-th time points,
respectively, out of total \eqn{m} time points, \eqn{1 \leq i, j \leq m}.
}
}

\seealso{
Other covariance types: 
\code{\link{as.cov_struct}()},
\code{\link{cov_struct}()}
}
\concept{covariance types}
