% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-db.R
\name{show_information_schema}
\alias{show_information_schema}
\title{Show Information Schema Schemas}
\usage{
show_information_schema(.con)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}
}
\value{
A tibble with one row per schema. Columns typically include
catalog name, schema name, schema owner, and other database-specific
metadata as defined by the SQL information schema.
}
\description{
List all schemas available in the connected database.

This function queries the \code{information_schema.schemata} view to return
metadata about schemas that exist in the database associated with the
provided DBI connection. It is intended for inspection and debugging
purposes and does not modify database state.
}
\details{
The structure and contents of the returned tibble depend on the database
backend. Databases may expose additional or fewer columns in
\code{information_schema.schemata}.
}
\examples{
\dontrun{
library(DBI)
con <- dbConnect(duckdb::duckdb())

show_information_schema(con)

dbDisconnect(con, shutdown = TRUE)
}
}
