#' @title Density and Random Function
#' @name priors
#' @description 
#'  
#'  Users must specify one of the two function types (\code{stats::?func}). 
#'    Either the Density Function (d-func) or the Random Function (r-func)
#'    
#'    \itemize{
#'      \item Density Function (\code{stats::dfunc}) represents the prior 
#'            distribution the free parameters are assumed to follow
#'      \item Random Function (\code{stats::rfunc}) represents the sampling 
#'            distribution for generating random numbers 
#'    }
#'    
#'    Users do not need to memorize when to input the d-func or the r-func; 
#'    the program will handle the necessary conversion automatically. Since 
#'    this conversion function relies on regular expressions for string 
#'    transformation, it is relatively brittle. Users must strictly follow the 
#'    examples provided below.
#' 
#' @section Class: 
#' \code{priors [List]} 
#' 
#' @section Density Function: 
#' \preformatted{ # standard format dfunc (Only the numerical values can be modified.)
#'  function(x) {stats::dbeta(x, shape1 = 2, shape2 = 2, log = TRUE)}
#'  function(x) {stats::dexp(x, rate = 1, log = TRUE)}
#'  function(x) {stats::dunif(x, min = 0, max = 1, log = TRUE)}
#'  function(x) {stats::dnorm(x, mean = 0.5, sd = 0.1, log = TRUE)}
#'  function(x) {stats::dlnorm(x, meanlog = 0.5, sdlog = 0.1, log = TRUE)}
#'  function(x) {stats::dgamma(x, shape = 2, rate = 3, log = TRUE)}
#'  function(x) {stats::dlogis(x, location = 0, scale = 1, log = TRUE)}
#' }
#' 
#' @section Random Function: 
#' \preformatted{ # standard format rfunc  (Only the numerical values can be modified.)
#'  function(x) {stats::rbeta(n = 1, shape1 = 2, shape2 = 2)}
#'  function(x) {stats::rexp(n = 1, rate = 1)}
#'  function(x) {stats::runif(n = 1, min = 0, max = 1)}
#'  function(x) {stats::rnorm(n = 1, mean = 0.5, sd = 0.1)}
#'  function(x) {stats::rlnorm(n = 1, meanlog = 0.5, sdlog = 0.1)}
#'  function(x) {stats::rgamma(n = 1, shape = 2, rate = 3)}
#'  function(x) {stats::rlogis(n = 1, location = 0, scale = 1)}
#' }
#' 
#' @section Example: 
#' \preformatted{ # TD
#'  params = list(
#'    free = list(
#'      alpha = x[1],
#'      beta = x[2]
#'    ),
#'    fixed = list(
#'      gamma = 1, 
#'      delta = 0.1, 
#'      epsilon = NA_real_, 
#'      zeta = 0
#'    ),
#'    constant = list(
#'      seed = 123,
#'      Q0 = NA_real_, 
#'      reset = NA_real_,
#'      lapse = 0.01,
#'      threshold = 1,
#'      bonus = 0,
#'      weight = 1,
#'      capacity = 0,
#'      sticky = 0
#'    )
#'  )
#'  
#'  priors = list(
#'    alpha = function(x) {stats::rbeta(n = 1, shape1 = 2, shape2 = 2)}, 
#'    beta = function(x) {stats::rexp(n = 1, rate = 1)}
#'  )
#' }
#' 

NULL