% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCensusData.R
\name{listCounties}
\alias{listCounties}
\title{List available counties for a state}
\usage{
listCounties(
  state_fips,
  year = 2024,
  csv_path = NULL,
  cache_dir = NULL,
  verbose = FALSE
)
}
\arguments{
\item{state_fips}{Two-digit FIPS code for the state}

\item{year}{Census year (2020-2024), default 2024}

\item{csv_path}{Optional path to a previously downloaded census CSV file}

\item{cache_dir}{Optional directory path for caching downloaded census files}

\item{verbose}{Logical, if TRUE prints messages about data loading. Default is FALSE.}
}
\value{
Character vector of county names
}
\description{
List available counties for a state
}
\examples{
# Use the included example data
utah_counties <- listCounties(
  state_fips = "49", 
  year = 2024,
  csv_path = getCensusDataPath()
)

\donttest{
# Download from web (requires internet)
utah_counties_web <- listCounties(state_fips = "49", year = 2024)

# With caching
utah_counties_cached <- listCounties(state_fips = "49", cache_dir = "~/census_cache")
}
}
