% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{build.base}
\alias{build.base}
\title{Build Base Pairwise Substitution}
\usage{
build.base(parts, type = NULL)
}
\arguments{
\item{parts}{A character vector specifying the names of compositional variables to be used.}

\item{type}{Either \code{"one-to-one"} or \code{"one-to-all"}. Default is \code{"one-to-one"}.}
}
\value{
A data table of all possible pairwise substitution.
}
\description{
Make a data set of all possible pairwise substitution of a composition which can be used as
the base for substitution models.
}
\examples{
ps1 <- build.base(parts = c("TST", "WAKE", "MVPA", "LPA", "SB"))
print(ps1)

ps2 <- build.base(c("WAKE", "MVPA", "LPA", "SB"), type = "one-to-all")
print(ps2)
}
