% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regress.R
\name{reconstruct.regress}
\alias{reconstruct.regress}
\title{Reconstruct fitted or subsetted outputs for a \code{regress} object}
\usage{
\method{reconstruct}{regress}(
  x,
  comp = 1:ncol(x$coefficients),
  rowind = 1:nrow(scores(x)),
  colind = 1:nrow(x$coefficients),
  ...
)
}
\arguments{
\item{x}{A \code{regress} object produced by \code{regress()}.}

\item{comp}{Integer vector of component indices (columns of the design matrix / predictors) to use.}

\item{rowind}{Integer vector of row indices in the design matrix (observations) to reconstruct.}

\item{colind}{Integer vector of output indices (columns of Y) to reconstruct.}

\item{...}{Ignored.}
}
\description{
For regression-based bi_projectors, reconstruction should map from the
design matrix side (scores) to the output space using the regression
coefficients, without applying any reverse preprocessing (which belongs
to the input/basis side).
}
