% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mumarinex.R
\name{mumarinex}
\alias{mumarinex}
\title{MUMARINEX and subindices computation}
\usage{
mumarinex(x, ref, subindices = FALSE)
}
\arguments{
\item{x}{A data frame or a matrix organized with samples in rows and species in columns.}

\item{ref}{A logical or numeric vector identifying the reference row positions.}

\item{subindices}{A logical indicating whether the sub-indices (CSR, CBCD, and CPI) should be returned.}
}
\value{
A data frame with the MUMARINEX values. When subindices = TRUE, an additional data frame is returned containing the results of the sub-indices (CSR, CBCD, and CPI).
}
\description{
Computes the MUMARINEX index and its sub-indices (CSR, CBCD, and CPI), following the method described in Chauvel et al. (2025).
}
\details{
mumarinex
}
\examples{
data("Simulated_data")
ref_idx<-41:50
mumarinex(x=Simulated_data,ref=ref_idx)
mumarinex(x=Simulated_data,ref=ref_idx,subindices=TRUE)
}
\references{
Chauvel, N., Pezy, J.P., Grall, J., Thiébaut, E. (2025). A general-purpose Multivariate Marine Recovery Index for quantifying the influence of human activities on benthic habitat ecological status. Ecological Indicator.
}
