% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_theory.R
\name{normal_form}
\alias{normal_form}
\title{Hook's OPTIC normal forms}
\usage{
normal_form(set, optic = "opc", edo = 12, rounder = 10)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{optic}{String: the OPTIC symmetries to apply. Defaults to "opc".}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
Numeric vector with the desired normal form of \code{set}
}
\description{
Following Hook (2023, 416-18, ISBN: 9780190246013), calculates a normal
form for the input \code{set} using any combination of OPTIC symmetries.
}
\details{
This function is designed for flexibility in the \code{optic} parameter, not speed.
In situations where you need to calculate a large number of OPTIC- or OPTC-normal
forms, you should use \code{primeform()} or \code{tnprime()} respectively, which are considerably
faster.
}
\examples{
# See Exercise 10.4.8 in Hook (2023, 420):
eroica <- c(-25, -13, -6, -3, 0, 3)
normal_form(eroica, optic="pti")
normal_form(eroica, optic="op")

# See Table 10.4.1 in Hook (2023, 417):
alpha <- c(-5, -11, 14, 9, 14, 14, 2)
num_symmetries <- sample(0:5, 1)
random_symmetries <- sample(c("o", "p", "t", "i", "c"), num_symmetries)
random_symmetries <- paste(random_symmetries, collapse="")
print(random_symmetries)
normal_form(alpha, optic=random_symmetries)

}
\seealso{
\code{\link[=primeform]{primeform()}}, \code{\link[=tnprime]{tnprime()}}, and \code{\link[=startzero]{startzero()}} for faster functions
dedicated to specific symmetry combinations
}
