% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmvmr_main.R
\name{mvfmr_separate}
\alias{mvfmr_separate}
\title{Separate Univariable Functional Mendelian Randomization}
\usage{
mvfmr_separate(
  G1,
  G2,
  fpca_results,
  Y,
  outcome_type = c("continuous", "binary"),
  method = c("gmm", "cf", "cf-lasso"),
  nPC1 = NA,
  max_nPC1 = NA,
  nPC2 = NA,
  max_nPC2 = NA,
  improvement_threshold = 0.001,
  bootstrap = FALSE,
  n_bootstrap = 100,
  n_cores = parallel::detectCores() - 1,
  true_effects = NULL,
  X_true = NULL,
  verbose = FALSE
)
}
\arguments{
\item{G1}{Genetic instrument matrix for exposure 1}

\item{G2}{Genetic instrument matrix for exposure 2, or NULL if only a single exposure is analyzed}

\item{fpca_results}{List of FPCA objects}

\item{Y}{Outcome vector}

\item{outcome_type}{Type of outcome: "continuous" for numeric outcomes, "binary" for 0/1 outcomes}

\item{method}{Estimation method: "gmm" (Generalized Method of Moments), "cf" (control function), or "cf-lasso" (control function with Lasso)}

\item{nPC1}{Fixed number of principal components to retain for exposure 1 (NA = select automatically)}

\item{max_nPC1}{Maximum number of principal components to retain for exposure 1 (NA = automatically determined)}

\item{nPC2}{Fixed number of principal components to retain for exposure 2 (NA = select automatically)}

\item{max_nPC2}{Maximum number of principal components to retain for exposure 2 (NA = automatically determined)}

\item{improvement_threshold}{Minimum cross-validation improvement required to add an additional principal component}

\item{bootstrap}{Whether to compute confidence intervals using bootstrap resampling}

\item{n_bootstrap}{Number of bootstrap replicates (only used if bootstrap = TRUE)}

\item{n_cores}{Number of CPU cores to use for parallel computations}

\item{true_effects}{List with true_effect1 and true_effect2 (simulation only)}

\item{X_true}{List with X1_true and X2_true curves (simulation only)}

\item{verbose}{Print progress and diagnostic messages during computation}
}
\value{
fmvmr_separate object
}
\description{
Separate Univariable Functional Mendelian Randomization
}
