% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_signature_transformed.R
\docType{data}
\name{COUNT_TRANSFORMS}
\alias{COUNT_TRANSFORMS}
\title{Count Transformation Functions}
\format{
A named list of transformation functions:
\describe{
  \item{none}{Identity transformation (no change)}
  \item{sqrt}{Square root transformation}
  \item{log2}{log2(x+1) transformation}
  \item{vst}{Variance stabilizing transformation (DESeq2)}
  \item{rlog}{Regularized log transformation (DESeq2)}
  \item{rank}{Rank transformation within each sample}
}
}
\usage{
COUNT_TRANSFORMS
}
\description{
Predefined list of transformation functions for count data normalization.
}
\details{
This object provides a list of predefined transformation functions for gene expression matrix.
For `rlog()` and `vst()` transformations (from `DESeq2`), the expression matrix is multiplied 
by 2 prior to rounding. 
This is done to preserve more information for the lower expression values (especially for TPM).
}
\keyword{datasets}
