% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genes_filter.R
\name{genes_filter_dynamic}
\alias{genes_filter_dynamic}
\title{Filter Dynamic Expression Genes}
\usage{
genes_filter_dynamic(e, thr = 0.9)
}
\arguments{
\item{e}{Matrix of expression values with genes as rows and samples as columns}

\item{thr}{Threshold quantile for variance filtering (default: 0.9)}
}
\value{
Matrix containing only genes above the variance threshold
}
\description{
Filter genes based on expression variance to select the most dynamically expressed genes.
}
\details{
This function calculates the variance for each gene across samples and retains
only genes with variance above the specified quantile threshold. This helps
focus analysis on genes that show significant expression changes.
# Filter top 10% most variable genes
# filtered_expr <- genes_filter_dynamic(expression_matrix, thr = 0.9)
}
\keyword{internal}
