% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloset_bulk.R
\name{match_map}
\alias{match_map}
\title{Match Gene Expression Data with Phylostratum Map}
\usage{
match_map(
  data,
  phylomap,
  groups = colnames(data[, 2:ncol(data)]),
  name = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame where column 1 contains gene IDs and columns 2+ contain expression data}

\item{phylomap}{A data frame with two columns: phylostratum assignments and gene IDs}

\item{groups}{A factor or character vector indicating which group each sample belongs to.
Default uses column names from expression data}

\item{name}{A character string naming the dataset. Default uses the variable name}

\item{...}{Additional arguments passed to as_BulkPhyloExpressionSet}
}
\value{
A BulkPhyloExpressionSet object
}
\description{
Join gene expression data with a phylostratum mapping to create 
a BulkPhyloExpressionSet object.
}
\examples{
# Match expression data with phylostratum map
# bulk_set <- match_map(expression_data, phylo_map, 
#                       groups = c("stage1", "stage2", "stage3"),
#                       name = "Matched Dataset")

}
