% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_reductive_hourglass_test.R
\name{stat_reductive_hourglass_test}
\alias{stat_reductive_hourglass_test}
\title{Reductive Hourglass Test}
\usage{
stat_reductive_hourglass_test(phyex_set, modules, ...)
}
\arguments{
\item{phyex_set}{A PhyloExpressionSet object}

\item{modules}{A named list with elements 'early', 'mid', and 'late' containing
stage indices for each developmental module}

\item{...}{Additional arguments passed to stat_generic_conservation_test}
}
\value{
A ConservationTestResult object with reductive hourglass test results
}
\description{
Test for reductive hourglass patterns in transcriptomic data by comparing
early and late developmental stages to mid developmental stages.
}
\details{
The reductive hourglass test evaluates whether mid developmental stages show
lower transcriptomic index values (indicating older genes) compared to both
early and late stages. This creates an hourglass-shaped pattern where ancient
genes dominate during mid-development. The test computes a score based on the
minimum difference between early vs. mid and late vs. mid TXI values.
}
\examples{
# Define developmental modules
modules <- list(early = 1:2, mid = 3:5, late = 6:7)
result <- stat_reductive_hourglass_test(example_phyex_set_old, modules=modules)

}
\seealso{
\code{\link{stat_generic_conservation_test}}, \code{\link{stat_reverse_hourglass_test}}
}
