% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_myrror_object.R
\name{create_myrror_object}
\alias{create_myrror_object}
\title{Creates a myrror object for comparing two data frames}
\usage{
create_myrror_object(
  dfx,
  dfy,
  by = NULL,
  by.x = NULL,
  by.y = NULL,
  factor_to_char = TRUE,
  verbose = getOption("myrror.verbose"),
  interactive = getOption("myrror.interactive")
)
}
\arguments{
\item{dfx}{a non-empty data.frame.}

\item{dfy}{a non-empty data.frame.}

\item{by}{character, key to be used for dfx and dfy.}

\item{by.x}{character, key to be used for dfx.}

\item{by.y}{character, key to be used for dfy.}

\item{factor_to_char}{TRUE or FALSE, default to TRUE.}

\item{verbose}{logical: If \code{TRUE} additional information will be displayed.}

\item{interactive}{logical: If \code{TRUE}, print S3 method for myrror objects
displays by chunks. If \code{FALSE}, everything will be printed at once.}
}
\value{
An object of class "myrror" containing comparison results, dataset information,
and various reports on matching/non-matching observations.
}
\description{
This function constructs a myrror object by comparing two data frames.
It handles the preparation, validation, and joining of datasets, identifies
matching and non-matching observations, and performs column pairing for comparison.
The function supports various join types (1:1, 1:m, m:1) and provides detailed
reports on the comparison results.
}
\examples{
# convert rownames of mtcars to a column
mtcars2 <- mtcars
mtcars2$car_name <- rownames(mtcars2)
rownames(mtcars2) <- NULL
# modify mtcars2 slightly by remove one row and changing one value
mtcars3 <- mtcars2[-1, ]
mtcars3$mpg[1] <- mtcars3$mpg[1] + 1

mo <- create_myrror_object(mtcars2, mtcars3, by = "car_name")
mo
}
