% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata_helpers.R
\name{catalogs}
\alias{catalogs}
\alias{access_codes}
\alias{collections}
\alias{country_codes}
\alias{latest_entries}
\alias{metadata}
\title{Small Helper Functions for Data Catalog Access}
\usage{
catalogs(show = TRUE)

access_codes(catalog)

collections(catalog)

country_codes(catalog)

latest_entries(catalog, limit = NULL)

metadata(catalog, id)
}
\arguments{
\item{show}{Logical. If \code{TRUE}, prints supported catalogs to console}

\item{catalog}{A required character string specifying the name of the data
catalog (e.g., \code{"fao"}, \code{"ilo"}, \code{"wb"}) from which to retrieve metadata.}

\item{limit}{A positive integer number, applicable only to \code{latest_entries},
indicating the \strong{maximum number of results} (data entries) to return. If
\code{NULL} or omitted, a default limit set by the API will be used.}

\item{id}{A required \strong{study identifier}. Accepts either the numeric \strong{Study ID}
(integer, e.g., \code{101}) or the character \strong{Study ID Number} (string,
e.g., \code{"ALB_2012_LSMS_v01_M_v01_A_PUF"}). These values are typically
returned in the search results from \code{\link[=search_catalog]{search_catalog()}},
\code{\link[=latest_entries]{latest_entries()}} or \code{\link[=data_files]{data_files()}}.}
}
\value{
A \strong{data frame} containing the requested metadata, except for \code{metadata()},
which returns a \code{list}. The structure of the returned object varies by function:
\itemize{
\item \code{access_codes}: Returns a data frame with columns related to
data resource identifiers (e.g., \code{code}, \code{description}).
\item \code{collections}: Returns a data frame detailing data groupings
(e.g., \code{collection_id}, \code{name}).
\item \code{country_codes}: Returns a data frame of standard country
identifiers (e.g., \code{iso3c}, \code{country_name}).
\item \code{latest_entries}: Returns a data frame of the \strong{most recently}
added datasets or entries, with columns reflecting their general
metadata (e.g., \code{title}, \code{date_added}).
\item \code{metadata}: Returns a \strong{list} of the study metadata including detailed
description, abstract, sampling methodology, and other study-specific details.
}
If the API call fails or no data is found, the function may return an
empty data frame or raise an error.
}
\description{
A suite of small \strong{helper functions} designed to interact with and retrieve
essential metadata from various international organization data repositories
(catalogs). These functions standardize the process of obtaining lists of
available \strong{data access codes}, \strong{collections}, \strong{country codes}, and
\strong{latest entries} from specified sources.
}
\details{
All functions require a valid \code{catalog} name. The functions
communicate with a backend API (implied by \code{base_url} and \code{get_response})
to fetch the requested data in a standardized format. The validity of the
\code{catalog} is checked internally using \code{assert_catalog}.
}
\section{Supported Catalogs}{

The \code{catalog} argument must be one of the following short codes (case-insensitive)
corresponding to the respective microdata repository. \strong{The list is sorted alphabetically by code.}

\itemize{
\item \code{"df"}: \strong{Data First} (\href{https://www.datafirst.uct.ac.za}{https://www.datafirst.uct.ac.za})
\item \code{"erf"}: \strong{Economic Research Forum} (\href{https://erfdataportal.com}{https://erfdataportal.com})
\item \code{"fao"}: \strong{Food and Agriculture Organization} (\href{https://microdata.fao.org}{https://microdata.fao.org})
\item \code{"ihsn"}: \strong{International Household Survey Network} (\href{https://catalog.ihsn.org}{https://catalog.ihsn.org})
\item \code{"ilo"}: \strong{International Labour Organization} (\href{https://webapps.ilo.org/surveyLib}{https://webapps.ilo.org/surveyLib})
\item \code{"india"}: \strong{Government of India} (\href{https://microdata.gov.in}{https://microdata.gov.in})
\item \code{"unhcr"}: \strong{United Nations High Commissioner for Refugees} (\href{https://microdata.unhcr.org}{https://microdata.unhcr.org})
\item \code{"wb"}: \strong{The World Bank} (\href{https://microdata.worldbank.org}{https://microdata.worldbank.org})
}
}

\examples{
\dontrun{
# --- Examples for Supported Catalogs ---

# 1. Data First (df): Get available access codes.
df_codes <- access_codes("df")

# 2. Economic Research Forum (erf): Get latest data entries (limited to 5).
erf_latest <- latest_entries("erf", limit = 5)

# 3. Food and Agriculture Organization (fao): Get available collections.
fao_collections <- collections("fao")

# 4. International Household Survey Network (ihsn): Get supported country codes.
ihsn_countries <- country_codes("ihsn")

# 5. International Labour Organization (ilo): Get available access codes.
ilo_codes <- access_codes("ilo")

# 6. Government of India (india): Get latest data entries (limited to 10).
india_latest <- latest_entries("india", limit = 10)

# 7. United Nations High Commissioner for Refugees (unhcr): Get available collections.
unhcr_collections <- collections("unhcr")

# 8. The World Bank (wb): Get supported country codes.
wb_countries <- country_codes("wb")

# Example for the metadata function (requires a study ID)
wb_study_metadata <- metadata("wb", id = 8098)
str(wb_study_metadata)
}
}
\seealso{
The main search function: \code{\link{search_catalog}}
}
\author{
Gutama Girja Urago
}
