% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_learners.R
\name{binary_learners}
\alias{binary_learners}
\title{Binary Learners in \code{\{nadir\}}}
\description{
\itemize{
\item \code{lnr_nnet}
\item \code{lnr_rf_binary}
\item \code{lnr_logistic}
}
}
\details{
The important thing to know about binary learners is that they
need to produce predictions that the outcome is \code{ == 1} or \code{TRUE}.

Also, for binary outcomes, we should make sure to use the
\code{determine_weights_for_binary_outcomes} in our calls to
\code{super_learner()} which calculates the estimated probability of the observed
outcome (either 0 or 1) and then applies the negative log loss function
afterwards. This can be done automatically by declaring \code{outcome_type = 'binary'}
in calling \code{super_learner()}
}
\examples{
super_learner(
  data = mtcars,
  learners = list(logistic1 = lnr_logistic, logistic2 = lnr_logistic, lnr_rf_binary),
  formulas = list(
  .default = am ~ .,
  logistic2 = am ~ mpg * hp + .),
  outcome_type = 'binary'
  )

}
\seealso{
density_learners learners
}
\keyword{binary_learners}
