% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density_learners.R
\name{lnr_lm_density}
\alias{lnr_lm_density}
\title{Conditional Normal Density Estimation Given Mean Predictors}
\usage{
lnr_lm_density(data, formula, weights = NULL, ...)
}
\arguments{
\item{data}{A dataframe to train a learner / learners on.}

\item{formula}{A regression formula to use inside this learner.}

\item{weights}{Observation weights; see \code{?lm}}

\item{...}{Any extra arguments that should be passed to the internal model
for model fitting purposes.}
}
\value{
a closure (function) that produces density estimates
at the \code{newdata} given according to the fit model.
}
\description{
This is the simplest possible density estimator that is
entertainable.  It fits a \code{lm} model to the data, and
uses the variance of the residuals to parameterize a
model of the data as \eqn{\mathcal N(y | \beta x, \sigma^2)}.
}
\examples{
lnr_lm_density(mtcars, hp ~ mpg)(mtcars)
hp_seq <- seq(min(mtcars$hp), max(mtcars$hp), length.out = 1000)
plot(
  x = hp_seq,
  y = lnr_lm_density(mtcars, hp ~ mpg)(
    data.frame(hp = hp_seq, mpg = rep(mean(mtcars$mpg), 1000))),
  xlab = 'hp',
  ylab = 'density',
  main = 'normal density model of horsepower given mean(mpg)')

}
