% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/super_learner_helpers.R
\name{negative_log_loss}
\alias{negative_log_loss}
\title{Negative Log Loss}
\usage{
negative_log_loss(predicted_densities, ...)
}
\arguments{
\item{predicted_densities}{The predicted densities from a learner predicted at \code{newdata}.}

\item{...}{Because \code{nadir::compare_learners()} passes \code{estimates, truth} to the
\code{loss_metric} passed to it, \code{negative_log_loss} accepts ... but doesn't do anything
with it.}
}
\value{
A sum of the negative log loss given a vector of predicted probabilities/densities
for some observed outcome.
}
\description{
Negative Log Loss
}
\details{
\code{negative_log_loss} encodes the logic:
if \eqn{\hat p_n} is a good model of the conditional densities, then it should minimize:
\deqn{ -\sum(\log(\hat p_n(X_i)) }
}
\examples{
# suppose we have some prediction probabilities _at the true values_:
predicted_probabilities <- lnr_logistic(mtcars, am ~ hp)(mtcars)
# we can calculate the -log(loss) for binary predicted probabilities like so:
negative_log_loss(predicted_probabilities)
}
