% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screeners.R
\name{screener_cor}
\alias{screener_cor}
\title{Correlation Threshold Based Screening}
\usage{
screener_cor(data, formula, threshold = 0.2, cor... = NULL)
}
\arguments{
\item{data}{A dataframe intended to be used with \code{super_learner()}}

\item{formula}{The formula specifying the regression to be done}

\item{threshold}{The correlation coefficient cutoff, below which variables
are screened out from the dataset and regression formula.}

\item{cor...}{An optional list of extra arguments to pass to \code{cor}. Use
\code{method = 'spearman'} for the Spearman rank based correlation
coefficient.}
}
\value{
A list of \code{$data} with columns screened out,
\code{$formula} with variables screened out, and \code{$failed_to_correlate_names}
the names of variables that failed to correlate with the outcome at least at the threshold
level.
}
\description{
Correlation Threshold Based Screening
}
\details{
If a variable used has little correlation with the outcome being predicted,
we might want to screen that variable out from the predictors.

In large datasets, this is quite important, as having a huge number of
columns could be computationally intractable or frustratingly time-consuming
to run \code{super_learner()} with.
}
\examples{
screener_cor(
  data = mtcars,
  formula = mpg ~ .,
  threshold = .5)

# We're also showing how to specify that you want the Spearman rank-based
# correlation coefficient, to get away from the assumption of linearity.

screener_cor(
  data = mtcars,
  formula = mpg ~ .,
  threshold = .5,
  cor... = list(method = 'spearman')
  )
}
