#' Dataframe for PV module degradation under Damp Heat Exposure
#'
#' In this example, full size PV modules were exposed to damp heat conditions (relative humidity of 85\% and a chamber temperature of 85 deg C) for 4000 hours and the degradation in PV power output was measured at specific time intervals, or time steps.
#' In addition, some modules were withdrawn from the study at these time steps, to produce a retained sample library with samples available for each time step.
#' These retained samples were dismantled destructively in order to determine the changes occurred in the module materials.
#' In the resulting netSEM model, time was used as a proxy for damp heat exposure stress (S) variable and \eqn{P_{max}} (maximum power generated by the modules) was used as the performance level response (\eqn{R}) variable, several mechanistic variables (\eqn{M}) were obtained through chemical evaluation methods, including FTIR and TGA  on EVA encapsulant. 
#' This example also demonstrate how to add latent variables.
#' 
#' @docType data
#' @usage data(PVmodule)
#' @name PVmodule
#' @author Menghong Wang, Abdulkerim Gok, Roger H. French
#' 
#' @format A 16 by 4 data frame of continuous variables
#' \describe{
#'   \item{Pmax}{Maximum power generated by PV modules}
#'   \item{Time}{Time in decimal years for exposure of PV modules to damp heat conditions}
#'   \item{IREVA}{Infrared signal measurement that tracks hydrolysis of EVA encapsulant}
#'   \item{TGA}{Thermogravimetric analysis of PV module to track formation of acetic acid}
#' }
#' 
#' @source Solar Durability and Lifetime Extension (SDLE) Research Center, Case Western
#' Reserve University
#' 
"PVmodule"