% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array_like.R, R/clustered_neurovec.R
\name{extractor4d}
\alias{extractor4d}
\alias{[,ArrayLike4D,matrix,missing,ANY-method}
\alias{[,ArrayLike4D,numeric,numeric,ANY-method}
\alias{[,ArrayLike4D,numeric,missing,ANY-method}
\alias{[,ArrayLike4D,integer,missing,ANY-method}
\alias{[,ArrayLike4D,missing,missing,ANY-method}
\alias{[,ArrayLike4D,missing,numeric,ANY-method}
\alias{[,ClusteredNeuroVec,missing,missing,ANY-method}
\alias{[,ClusteredNeuroVec,numeric,numeric,ANY-method}
\title{Array-like access for 4-dimensional data structures}
\usage{
\S4method{[}{ArrayLike4D,matrix,missing,ANY}(x, i, j, k, m, ..., drop = TRUE)

\S4method{[}{ArrayLike4D,numeric,numeric,ANY}(x, i, j, k, m, ..., drop = TRUE)

\S4method{[}{ArrayLike4D,numeric,missing,ANY}(x, i, j, k, m, ..., drop = TRUE)

\S4method{[}{ArrayLike4D,integer,missing,ANY}(x, i, j, k, m, ..., drop = TRUE)

\S4method{[}{ArrayLike4D,missing,missing,ANY}(x, i, j, k, m, ..., drop = TRUE)

\S4method{[}{ArrayLike4D,missing,numeric,ANY}(x, i, j, k, m, ..., drop = TRUE)

\S4method{[}{ClusteredNeuroVec,missing,missing,ANY}(x, i, j, k, m, ..., drop = TRUE)

\S4method{[}{ClusteredNeuroVec,missing,missing,ANY}(x, i, j, k, m, ..., drop = TRUE)

\S4method{[}{ClusteredNeuroVec,numeric,numeric,ANY}(x, i, j, k, m, ..., drop = TRUE)
}
\arguments{
\item{x}{The 4-dimensional object to be accessed.}

\item{i}{First index or dimension.}

\item{j}{Second index or dimension.}

\item{k}{Third index or dimension.}

\item{m}{Fourth index or dimension.}

\item{...}{Additional arguments passed to methods.}

\item{drop}{Logical. If TRUE, the result is coerced to the lowest possible dimension.}
}
\value{
A subset of the input object, with dimensions depending on the indexing and the `drop` parameter.
}
\description{
This generic function provides array-like access for 4-dimensional data structures.
It allows for flexible indexing and subsetting of 4D arrays or array-like objects.

Provides array-like access to ClusteredNeuroVec objects, supporting 
extraction patterns like x[,,,t] to get 3D volumes at specific time points.
}
