% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/clustered_neurovec.R,
%   R/neurovec.R, R/neurovecseq.R, R/sparse_neurovec.R
\name{series}
\alias{series}
\alias{series,ClusteredNeuroVec,numeric-method}
\alias{series,NeuroVec,matrix-method}
\alias{series_roi,NeuroVec,matrix-method}
\alias{series,NeuroVec,ROICoords-method}
\alias{series_roi,NeuroVec,ROICoords-method}
\alias{series,NeuroVec,LogicalNeuroVol-method}
\alias{series,NeuroVec,NeuroVol-method}
\alias{series_roi,NeuroVec,LogicalNeuroVol-method}
\alias{series,NeuroVec,integer-method}
\alias{series,DenseNeuroVec,integer-method}
\alias{series,NeuroVec,numeric-method}
\alias{series_roi,NeuroVec,numeric-method}
\alias{series,NeuroVecSeq,integer-method}
\alias{series,NeuroVecSeq,numeric-method}
\alias{series,NeuroVecSeq,matrix-method}
\alias{series_roi,NeuroVecSeq,matrix-method}
\alias{series,AbstractSparseNeuroVec,ROICoords-method}
\alias{series,AbstractSparseNeuroVec,matrix-method}
\alias{series,AbstractSparseNeuroVec,numeric-method}
\alias{series,AbstractSparseNeuroVec,integer-method}
\title{Extract one or more series from object}
\usage{
series(x, i, ...)

\S4method{series}{ClusteredNeuroVec,numeric}(x, i, j, k, ...)

\S4method{series}{NeuroVec,matrix}(x, i)

\S4method{series_roi}{NeuroVec,matrix}(x, i)

\S4method{series}{NeuroVec,ROICoords}(x, i)

\S4method{series_roi}{NeuroVec,ROICoords}(x, i)

\S4method{series}{NeuroVec,LogicalNeuroVol}(x, i)

\S4method{series}{NeuroVec,NeuroVol}(x, i)

\S4method{series_roi}{NeuroVec,LogicalNeuroVol}(x, i)

\S4method{series}{NeuroVec,integer}(x, i, j, k, drop = TRUE)

\S4method{series}{DenseNeuroVec,integer}(x, i, j, k, drop = TRUE)

\S4method{series}{NeuroVec,numeric}(x, i, j, k, drop = TRUE)

\S4method{series_roi}{NeuroVec,numeric}(x, i, j, k, drop = TRUE)

\S4method{series}{NeuroVecSeq,integer}(x, i, j, k, drop = TRUE)

\S4method{series}{NeuroVecSeq,numeric}(x, i, j, k, drop = TRUE)

\S4method{series}{NeuroVecSeq,matrix}(x, i)

\S4method{series_roi}{NeuroVecSeq,matrix}(x, i)

\S4method{series}{AbstractSparseNeuroVec,ROICoords}(x, i)

\S4method{series}{AbstractSparseNeuroVec,matrix}(x, i)

\S4method{series}{AbstractSparseNeuroVec,numeric}(x, i, j, k)

\S4method{series}{AbstractSparseNeuroVec,integer}(x, i, j, k, drop = TRUE)
}
\arguments{
\item{x}{A NeuroVecSeq object}

\item{i}{A matrix of ROI coordinates (n x 3)}

\item{...}{additional arguments}

\item{j}{second dimension index}

\item{k}{third dimension index}

\item{drop}{whether to drop dimension of length 1}
}
\value{
A \code{list} or \code{array} containing the extracted series.

A matrix where each column represents a voxel's time series

A ROIVec object containing the time series for the specified ROI
}
\description{
This function extracts time series data from specific voxel coordinates in a 4D neuroimaging object.
It supports multiple ways of specifying the coordinates:
\itemize{
  \item Linear indices (1D)
  \item Grid coordinates (3D matrix)
  \item Individual x,y,z coordinates
}
}
\examples{
# Create a simple 4D neuroimaging vector (10x10x10 volume with 20 timepoints)
space <- NeuroSpace(c(10,10,10,20), c(1,1,1))
vec <- NeuroVec(array(rnorm(10*10*10*20), c(10,10,10,20)), space)

# Extract time series using linear indices
ts1 <- series(vec, 1:10)  # Get time series for first 10 voxels

# Extract time series using 3D coordinates
coords <- matrix(c(1,1,1, 2,2,2, 3,3,3), ncol=3, byrow=TRUE)
ts2 <- series(vec, coords)  # Get time series for 3 specific voxel locations

# Extract single time series using x,y,z coordinates
ts3 <- series(vec, 5, 5, 5)  # Get time series from middle voxel

}
\seealso{
\code{\link{series_roi}}
}
