% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NilsEstimate.R
\name{NilsEstimate}
\alias{NilsEstimate}
\alias{NilsEstimateBalanced}
\title{Estimate totals using the NILS hierarchical design}
\usage{
NilsEstimate(
  plot_data,
  tract_data,
  psus,
  category_psu_map,
  area = 46519242.1175867,
  tract_area = 196 * 100 * pi
)

NilsEstimateBalanced(
  plot_data,
  tract_data,
  auxiliaries,
  psus,
  category_psu_map,
  area = 46519242.1175867,
  tract_area = 196 * 100 * pi,
  size_of_neighbourhood = NULL
)
}
\arguments{
\item{plot_data}{A data frame with information about observations at the plot level.
Must contain (in order):
\enumerate{
\item The tract ID (integer) of the parent tract.
\item The category ID (integer) recorded for the plot.
\item The design weight (double) for the plot, conditional on the tract.
\item The observed value of the target variable (double).
}}

\item{tract_data}{A matrix with information about all sampled tracts,
including those where no relevant categories were found.
Must contain (in order):
\enumerate{
\item The tract ID (integer) of each sampled tract.
\item The PSU collection ID (integer) of the smallest PSU that contains the tract.
}}

\item{psus}{An ordered vector of PSU levels, from largest to smallest.}

\item{category_psu_map}{A matrix describing the categories used in the design.
Must contain (in order):
\enumerate{
\item The category ID (integer), as used in \code{plot_data}.
\item The PSU collection ID (integer) of the smallest PSU in which the category is sampled.
}}

\item{area}{The size of the area frame. Typically larger than the actual area of interest.}

\item{tract_area}{The area of a tract, expressed in the same units as the target variable.}

\item{auxiliaries}{A numeric matrix of auxiliary variables used for balancing. Must have the same
dimensions and order as \code{tract_data}.}

\item{size_of_neighbourhood}{An optional numeric vector specifying the neighbourhood size for
each PSU level.}
}
\value{
A \code{NilsEstimate} object, essentially a data frame with one row per category and the
following columns:
\describe{
\item{Cat. ID}{The category ID number.}
\item{Est. total}{The estimated total of the target variable within the category.}
\item{Est. variance}{The estimated variance of the total estimator within the category.}
\item{Positive tracts}{The number of tracts with at least one positive value of the
target variable in the category.}
}
}
\description{
Estimates the total of some variable surveyed under the NILS hierarchical sampling framework.
}
\details{
The function combines plot-level observations (\code{plot_data}), tract-level information
(\code{tract_data}), PSU hierarchy (\code{psus}), and category assignments (\code{category_psu_map}) to estimate
totals under the NILS sampling design.

\subsection{Variance estimation for spatially balanced sampling: \code{NilsEstimateBalanced}}{

In the balanced variant, variance is estimated using a local neighbourhood deviance measure.
The neighbourhood size defaults to 4 for the smallest PSU level and increases linearly with PSU
level size.

Covariance between categories belonging to different PSU levels are measured over their
intersection, i.e. on the smaller PSU collections.
Consequently, the smaller PSU collection also determines the local neighbourhood size.

It is possible to provide a matrix as \code{psus} instead of a vector. This matrix should contain:
\enumerate{
\item PSU IDs, ordered from largest to smallest (by PSU size).
\item The neighbourhood size for each PSU.
}

If \code{psus} is provided as a vector, the neighbourhood size of PSU \eqn{k} defaults to
\deqn{4 \frac{n_{k}}{n_{(0)}} ,}
where \eqn{n_{k}} is the size of PSU collection \eqn{k}, and \eqn{n_{(0)}} is the size of the
smallest PSU collection.
}
}
\examples{
obj = NilsEstimate(plots, tracts, psus, category_psu_map);

obj = NilsEstimateBalanced(
  plots,
  tracts,
  tract_auxiliaries,
  psus,
  category_psu_map
);

}
