% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelGen.R
\name{auto_param_table}
\alias{auto_param_table}
\title{Automatically generate a parameter table with initial estimates}
\usage{
auto_param_table(
  dat = NULL,
  param_table = NULL,
  nlmixr2autoinits = TRUE,
  foldername = NULL,
  filename = "test",
  out.inits = TRUE,
  ...
)
}
\arguments{
\item{dat}{A data frame containing observed data (required if
\code{nlmixr2autoinits = TRUE}).}

\item{param_table}{Optional. A user-provided parameter table (if
provided, all other logic is skipped).}

\item{nlmixr2autoinits}{Logical. Whether to automatically estimate
initial values using \code{getPPKinits()}. Default is \code{TRUE}.}

\item{foldername}{Character string specifying the folder name for storing
\code{nlmixr2autoinits} outputs. If \code{NULL} (default), \code{tempdir()}
is used for temporary storage. If specified, a cache directory
is created in the current working directory.}

\item{filename}{Character string specifying the base name for model output
files generated during evaluation.}

\item{out.inits}{Logical flag indicating whether the results returned
by the automated initialization procedure should be saved to an RDS
file. When TRUE, the output of the initialization step is written to
disk for reproducibility or debugging purposes.}

\item{...}{Additional arguments passed to \code{getPPKinits()}.}
}
\value{
A \code{data.frame} representing the parameter table with initial
estimates, ready for use in \code{nlmixr2()}.
}
\description{
Constructs a parameter table for nlmixr2 model fitting. It supports:
\itemize{
\item Direct use of a user-provided parameter table.
\item Automatic initialization of parameters from data using
\code{getPPKinits()}.
\item Fallback to a default parameter table created by
\code{initialize_param_table()}.
}
}
\details{
When \code{nlmixr2autoinits = TRUE}, this function estimates initial values
from data, applies a name mapping to internal model parameters,
performs log transformations where appropriate, and replaces
problematic log values (e.g. log(0) or \code{NA}) with \code{log(0.01)} for
numerical stability.
}
\examples{
\donttest{
auto_param_table(dat = pheno_sd)
}
}
\seealso{
\code{\link[nlmixr2autoinit:getPPKinits]{getPPKinits}},
\code{\link{initialize_param_table}}
}
\author{
Zhonghui Huang
}
