% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabu.cores.R
\name{generate_neighbors_df}
\alias{generate_neighbors_df}
\title{Generate neighbor models}
\usage{
generate_neighbors_df(
  current_string,
  search.space = c("ivbase", "oralbase"),
  nsize = NULL
)
}
\arguments{
\item{current_string}{A named numeric vector representing the current
model code. Names correspond to model features (e.g. "no.cmpt",
"eta.vc", "rv"), and values to their current states.}

\item{search.space}{Character, one of "ivbase" or "oralbase".
Default is "ivbase".}

\item{nsize}{Integer (optional). Maximum number of neighbors
to return. If NULL (default), the full neighborhood is returned.
If specified, a random subset of this size is sampled.}
}
\value{
A list with two components:
\describe{
\item{original}{Neighbors generated by single-variable flips, before
validation.}
\item{validated}{Neighbors after validation, representing feasible
models.}
}
}
\description{
Generates a set of neighbor models from a given current model code.
The neighborhood is defined as all single-variable changes
(1-bit modifications).
}
\details{
For each neighbor, both the original (pre-validation) and the
validated (post-validation) codes are retained. This allows
downstream functions (e.g. \code{detect_move()}) to distinguish
between the intended primary modification and any secondary
adjustments introduced by validation.

Optionally, the function can restrict the number of neighbors
by random sampling (candidate list strategy).
}
\examples{
current_string <- c(no.cmpt = 2, eta.km = 0, eta.vc = 1,
                    eta.vp = 0, eta.vp2 = 0, eta.q = 1,
                    eta.q2 = 0, mm = 0, mcorr = 1, rv = 2)
neighbors <- generate_neighbors_df(current_string, search.space = "ivbase")
head(neighbors$original)   # raw neighbors (pre-validation)
head(neighbors$validated)  # validated neighbors (post-validation)

}
\author{
Zhonghui Huang
}
