% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_figures.R
\name{write_figure}
\alias{write_figure}
\title{Writes Figures to File}
\usage{
write_figure(
  p_res = NULL,
  page = NULL,
  width = 3,
  height = 3,
  resolution = NULL,
  fig_file = NULL,
  fig_stamp = NULL,
  verbose = TRUE
)
}
\arguments{
\item{p_res}{ggplot, ggforce paginated object, or ggarrange object.}

\item{page}{Page number to write or NULL for a ggplot object.}

\item{width}{Width in inches.}

\item{height}{Height in inches.}

\item{resolution}{resolution in dpi.}

\item{fig_file}{File name to write the figure to.}

\item{fig_stamp}{Character object containing the text to stamp on the figure with optional ===file=== placeholder.}

\item{verbose}{Boolean variable when set to TRUE (default) messages will be.
displayed on the terminal}
}
\value{
list with the following
\itemize{
\item \code{"isgood"} - Boolean variable indicating success or failure
\item \code{"msgs"} - Vector of messages
}
}
\description{
Takes a figure object, optionally
stamps the image, and writes to a file
dimensions of the figure.
}
\examples{
library(ggplot2)
write_figure(
 p_res = ggplot(),
 page = NULL,
 width = 3,
 height = 3,
 resolution = 200,
 fig_file = file.path(tempdir(), "write_figure_example.png"),
 fig_stamp = "stamp",
 verbose = TRUE)
}
