% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dominance_index.R
\name{dominance_index}
\alias{dominance_index}
\title{Dominance Index for Nominal Variables}
\usage{
dominance_index(df, var)
}
\arguments{
\item{df}{A data.frame or tibble containing the nominal variable.}

\item{var}{Character. Name of the nominal variable in \code{df}.}
}
\value{
A numeric value representing dominance.
}
\description{
Computes dominance for a nominal variable using the Simpson index,
quantifying the degree to which a few categories dominate the distribution.
}
\details{
Dominance is calculated as:
\deqn{D = \sum p_i^2}
where \eqn{p_i} is the relative frequency of category \eqn{i}.

Higher values indicate stronger dominance by fewer categories.
}
\examples{
dominance_index(categories, "animal")
dominance_index(categories2, "animal")
dominance_index(categories3, "animal")

}
