% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/association_matrix.R
\name{association_matrix}
\alias{association_matrix}
\title{Create an association matrix from a nugget of flavour \code{associations}.}
\usage{
association_matrix(
  x,
  value,
  error_context = list(arg_x = "x", arg_value = "value", call = current_env())
)
}
\arguments{
\item{x}{A nugget of flavour \code{associations}.}

\item{value}{A tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the column to use for filling the matrix values.}

\item{error_context}{A list of details to be used in error messages.
It must contain:
- \code{arg_x}: the name of the \code{x} argument;
- \code{arg_value}: the name of the \code{value} argument;
- \code{call}: an environment in which to evaluate the error messages.
Defaults to the current environment.}
}
\value{
A numeric matrix with row names corresponding to antecedents and
column names corresponding to consequents. Values are taken from the
column specified by \code{value}. Missing values are filled with zeros.
}
\description{
The association matrix is a matrix where rows correspond to antecedents,
columns correspond to consequents, and the values are taken from a specified
column of the nugget. Missing values are filled with zeros.

A pair of antecedent and consequent must be unique in the nugget. If there are
multiple rows with the same pair, an error is raised.
}
\examples{
d <- partition(mtcars, .breaks = 2)
rules <- dig_associations(d,
                          antecedent = everything(),
                          consequent = everything(),
                          min_support = 0.3)
association_matrix(rules, confidence)
}
\author{
Michal Burda
}
