% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_detention_admissions.R
\name{nyc_detention_admissions}
\alias{nyc_detention_admissions}
\title{NYC Detention Admissions by Community District}
\source{
NYC Open Data: <https://data.cityofnewyork.us/resource/2hrw-qfsu>
}
\usage{
nyc_detention_admissions(limit = 10000, filters = list())
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}
}
\value{
A tibble containing NYC Detention Admissions by Community District data.
}
\description{
Downloads Detention Admissions by Community District data from NYC Open Data.
}
\details{
This dataset reports annual counts of detention admissions across NYC community
districts, disaggregated by borough and calendar year. Provided by the NYC
Department of Correction and Department of Youth and Community Development.
}
\examples{
# Quick example (fetch 10 rows)
small_sample <- nyc_detention_admissions(limit = 10)
head(small_sample)

\donttest{
nyc_detention_admissions(limit = 5000)
nyc_detention_admissions(filters = list(borough = "Bronx"))
}
}
