% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{odiffr_update}
\alias{odiffr_update}
\title{Download Latest odiff Binary}
\usage{
odiffr_update(version = "latest", force = FALSE)
}
\arguments{
\item{version}{Character string specifying the version to download.
Use \code{"latest"} (default) to download the most recent release, or
specify a version tag like \code{"v4.1.2"}.}

\item{force}{Logical; if \code{TRUE}, re-download even if the binary already
exists in the cache. Default is \code{FALSE}.}
}
\value{
Character string with the path to the downloaded binary.
}
\description{
Downloads the odiff binary from GitHub releases to the user's cache
directory. The downloaded binary will be used by \code{find_odiff()} if no
system-wide installation or user-specified path is found.
}
\examples{
\dontrun{
# Download latest version
odiffr_update()

# Download specific version
odiffr_update(version = "v4.1.2")

# Force re-download
odiffr_update(force = TRUE)
}
}
