% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od.2.mod.R
\name{od.2.mod}
\alias{od.2.mod}
\title{Optimal sample allocation calculation for two-level CRTs probing
    moderation effects with cluster-level moderators}
\usage{
od.2.mod(
  d = NULL,
  gamma = NULL,
  n = NULL,
  Q = 0.5,
  p = NULL,
  icc = NULL,
  c1 = NULL,
  c1t = NULL,
  c2 = NULL,
  c2t = NULL,
  r12 = NULL,
  r22 = NULL,
  r12m = NULL,
  r22m = NULL,
  m = NULL,
  binary = TRUE,
  q.main = 1,
  q.mod = 1,
  power.mod = 0.8,
  power.main = 0.8,
  d.p = c(0.1, 0.5),
  d.n = c(2, 1000),
  sig.level = 0.05,
  two.tailed = TRUE,
  Jlim = NULL,
  verbose = TRUE,
  nrange = c(1.5, 10000),
  max.value = Inf,
  max.iter = 300,
  e = 1e-10,
  n.of.ants = 10,
  n.of.archive = 50,
  q = 1e-04,
  xi = 0.5
)
}
\arguments{
\item{d}{The standardized main or average treatment effect.}

\item{gamma}{The standardized moderated treatment effect
(i.e., regression coefficient of the interaction
term of moderator and treatment).}

\item{n}{The level-1 sample size per level-2 unit.}

\item{Q}{The proportion of binary moderator that coded as 1.
Default is 0.50.}

\item{p}{The proportion of level-2 clusters/units to be assigned to treatment.}

\item{icc}{The unconditional intraclass correlation coefficient (ICC) in population or in
each treatment condition.}

\item{c1}{The cost of sampling one level-1 unit in control condition.}

\item{c1t}{The cost of sampling one level-1 unit in treatment condition.}

\item{c2}{The cost of sampling one level-2 unit in control condition.}

\item{c2t}{The cost of sampling one level-2 unit in treatment condition.}

\item{r12}{The proportion of level-1 variance explained by covariates.}

\item{r22}{The proportion of level-2 variance explained by covariates.}

\item{r12m}{The proportion of outcome variance at the individual level
explained by covariates in the model with the moderator.}

\item{r22m}{The proportion of outcome variance at the cluster level
explained by covariates in the model with the moderator.}

\item{m}{Total budget.}

\item{binary}{Logical; The moderator is binary if TRUE,
and continuous if FALSE. The default is TRUE.}

\item{q.main}{The  number of covariates in the outcome model testing main
effects (except the treatment indicator). The default value is 1.}

\item{q.mod}{The number of cluster-level covariates in the model
(except the treatment indicator, moderator, and the interaction term).
The default value is 1.}

\item{power.mod}{Statistical power specified for moderation.
The default value is .80.}

\item{power.main}{Statistical power specified for the total/main effect.
The default value is .80.}

\item{d.p}{The initial sampling domain for p. Default is c(0.1, 0.5).}

\item{d.n}{The initial sampling domain for n. Default is c(2, 100).}

\item{sig.level}{Significance level or type I error rate, default value is 0.05.}

\item{two.tailed}{Two tailed test, the default value is TRUE.}

\item{Jlim}{The range for J to solve for a numerical solution.
Default is c(max(q.mod, q.main)+7, 1e6).}

\item{verbose}{Print out evaluation process if TRUE, default is TRUE.}

\item{nrange}{The range of the individual-level sample size per cluster
that used to exclude unreasonable values. Default value is c(1.5, 10000).}

\item{max.value}{Maximal value of optimization when used as
the stopping criterion. Default is -Inf.}

\item{max.iter}{Maximal number of function evaluations when used as
the stopping criterion.}

\item{e}{Maximum error value used when solution quality used as
the stopping criterion, default is 1e-10.}

\item{n.of.ants}{Number of ants used in each iteration after the initialization
of power analysis for calculating required budget, default value is 10.}

\item{n.of.archive}{Size of the solution archive, default is 100.}

\item{q}{Locality of the search (0,1), default is 0.0001.}

\item{xi}{Convergence pressure (0, Inf), suggested: (0, 1), default is 0.5.}
}
\value{
Unconstrained or constrained optimal sample allocation
    (\code{n} and \code{p}).
    The function also returns
    function name, design type,
    and parameters used in the calculation.
}
\description{
The optimal design of two-level
    cluster randomized trials (CRTs) probing moderation effects with
    cluster-level moderators is to to identify
    the optimal sample allocation that requires the minimum budget
    to achieve a certain power level.
    The optimal design parameters include
    the level-1 sample size per level-2 unit (\code{n})
    and the proportion of level-2 clusters/groups to be assigned to
    treatment (\code{p}).
    This function solves the optimal \code{n} and/or \code{p}
    with and without a constraint.
}
