% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.power.R
\name{plot.power}
\alias{plot.power}
\title{Plot statistical power curves under a fixed budget across optimal design
parameters}
\usage{
\method{plot}{power}(
  expr = NULL,
  nlim = c(2, 300),
  plim = c(0.01, 0.99),
  Jlim = c(3, 300),
  n = NULL,
  p = NULL,
  J = NULL,
  powerlim = c(0, 1),
  plot.title = NULL,
  m = NULL,
  d = NULL,
  gamma = NULL,
  omega = NULL,
  power = 0.8,
  q = NULL,
  by = c("n", "p", "J"),
  legend = TRUE,
  nlab = "Level-One Sample Size (n)",
  plab = "Proportion (p)",
  Jlab = "Level-Two Sample Size (J)",
  powerlab = "Statistical Power"
)
}
\arguments{
\item{expr}{Returned objects from an od function (e.g., od.2m, od.2m.mod).}

\item{nlim}{The limits of the level-1 sample size (n) for calculating
and plotting power curves.}

\item{plim}{The limits of the proportion to the treated (p) for calculating
and plotting power curves.}

\item{Jlim}{The limits of the level-2 sample size (J) for calculating
and plotting power curves.}

\item{n}{The sample size at level 1 per level-2 unit.}

\item{p}{The proportion of units in the treatment condition.}

\item{J}{Level-2 sample size.}

\item{powerlim}{The power limit for plotting power curves.}

\item{plot.title}{The title of the plot (e.g., plot.title = "Power Curves").
The default is NULL.}

\item{m}{Total budget, default is the total costs of sampling 60
sites.}

\item{d}{Standardized effect size for a main/average effect.}

\item{gamma}{Standardized effect size for a moderation effect.}

\item{omega}{The treatment-by-site variance.}

\item{power}{Statistical power.}

\item{q}{The number of covariates.}

\item{by}{Dimensions to plot power curves by the optimal design parameters.
The default value is by all optimal design parameters for a type of design.
For example, default values are by = "p" for single-level designs,
by = c("n", "p") for two-level designs,
and by = c("n", "p", "J") for three-level designs.}

\item{legend}{Logical; present plot legend if TRUE. The default is TRUE.}

\item{nlab}{Label for the x-axis when the plot is by the optimal design
parameter "n".}

\item{plab}{Label for the x-axis when the plot is by the optimal design
parameter "p".}

\item{Jlab}{Label for the x-axis when the plot is by the optimal design
parameter "J".}

\item{powerlab}{The label for the statistical power.}
}
\description{
This function plots statistical power curves (for main,
    moderation, and/or mediation effects) under a fixed budget
    across optimal design parameters.
}
