% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glean_gbif.R
\name{glean_gbif}
\alias{glean_gbif}
\title{Parse data from requests to GBIF}
\usage{
glean_gbif(res, cols = NULL, returnunique = FALSE)
}
\arguments{
\item{res}{a list of responses from GBIF as an \code{ohvbd.responses} object.}

\item{cols}{a character vector of columns to extract from the dataset.}

\item{returnunique}{whether to return only the unique rows within each dataset according to the filtered columns.}
}
\value{
An \code{ohvbd.data.frame} containing the requested data.
}
\description{
Extract the data returned by a call to \code{\link[=fetch_gbif]{fetch_gbif()}}, filter columns of interest, and find unique rows if required.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
fetch_gbif("dbc4a3ae-680f-44e6-ab25-c70e27b38dbc") |>
  glean_gbif()

ohvbd.ids("dbc4a3ae-680f-44e6-ab25-c70e27b38dbc", "gbif") |>
  fetch() |>
  glean() # Calls glean_gbif()
\dontshow{\}) # examplesIf}
}
\author{
Francis Windram
}
\concept{gbif}
